<?php

namespace App\Service;

use App\Entity\PlanCollage;
use App\Entity\PoutrePosition;
use Doctrine\ORM\EntityManagerInterface;

class NumeroSerieGenerator
{
    private EntityManagerInterface $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }
    public function attribuerNumerosSerie(PlanCollage $plan): void
    {
        $numeroCourant = 81200; // ou le dernier n° utilisé (voir remarque ci-dessous)
        $regroupementMap = [];
        
        foreach ($plan->getPositions() as $position) {
            if ($position->getRegroupementId()) {
                $regroupementId = $position->getRegroupementId();

                if (!isset($regroupementMap[$regroupementId])) {
                    $regroupementMap[$regroupementId] = $numeroCourant++;
                }

                $position->setNumeroSerie($regroupementMap[$regroupementId]);
            } else {
                $position->setNumeroSerie($numeroCourant++);
            }
            $this->em->persist($position);
        }
         $this->em->flush();        
    }
}
