<?php namespace App\Service;

class JoursFeriesService
{
    public function estFerie(\DateTimeInterface $date): bool
    {
        $jour = (int) $date->format('j');
        $mois = (int) $date->format('n');
        $annee = (int) $date->format('Y');

        // Fêtes fixes (France)
        $joursFeries = [
            sprintf('%d-01-01', $annee), // Jour de l'an
            sprintf('%d-05-01', $annee), // Fête du travail
            sprintf('%d-05-08', $annee), // Victoire 1945
            sprintf('%d-07-14', $annee), // Fête nationale
            sprintf('%d-08-15', $annee), // Assomption
            sprintf('%d-11-01', $annee), // Toussaint
            sprintf('%d-11-11', $annee), // Armistice
            sprintf('%d-12-25', $annee), // Noël
        ];

        // Fêtes mobiles
        $paques = (new \DateTime())->setDate($annee, 3, 21)->modify('+' . easter_days($annee) . ' days');
        $joursFeries[] = $paques->format('Y-m-d');                          // Pâques
        $joursFeries[] = $paques->modify('+1 day')->format('Y-m-d');       // Lundi de Pâques
        $joursFeries[] = (clone $paques)->modify('+38 days')->format('Y-m-d'); // Ascension
        $joursFeries[] = (clone $paques)->modify('+49 days')->format('Y-m-d'); // Pentecôte
        $joursFeries[] = (clone $paques)->modify('+50 days')->format('Y-m-d'); // Lundi de Pentecôte

        return in_array($date->format('Y-m-d'), $joursFeries);
    }
}
