<?php

namespace App\Repository;

use App\Entity\Affaire;
use App\Entity\Regroupement;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;

/**
 * @extends ServiceEntityRepository<Regroupement>
 */
class RegroupementRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Regroupement::class);
    }
    
    public function findByAffaire(Affaire $affaire): array
    {
        return $this->createQueryBuilder('r')
            ->andWhere('r.affaire = :affaire')
            ->setParameter('affaire', $affaire)
            ->getQuery()
            ->getResult();
    }


}
