<?php

namespace App\Repository;

use App\Entity\PlanCollage;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PlanCollage>
 */
class PlanCollageRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PlanCollage::class);
    }
    public function findByBancAndDate(\App\Entity\Banc $banc, \DateTimeInterface $date): array
    {
        $start = new \DateTime($date->format('Y-m-d 00:00:00'));
        $end = new \DateTime($date->format('Y-m-d 23:59:59'));


        return $this->createQueryBuilder('p')
            ->andWhere('p.banc = :banc')
            ->andWhere('p.dateCollage BETWEEN :start AND :end')
            ->setParameter('banc', $banc)
            ->setParameter('start', $start)
            ->setParameter('end', $end)
            ->getQuery()
            ->getResult();
    }

    public function collageExiste(int $bancId, \DateTimeInterface $date, string $heure): bool
    {
        return (bool) $this->createQueryBuilder('p')
            ->select('COUNT(p.id)')
            ->where('p.banc = :banc')
            ->andWhere('p.date = :date')
            ->andWhere('p.heure = :heure')
            ->setParameter('banc', $bancId)
            ->setParameter('date', $date)
            ->setParameter('heure', $heure)
            ->getQuery()
            ->getSingleScalarResult();
    }

    //    /**
    //     * @return PlanCollage[] Returns an array of PlanCollage objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('p')
    //            ->andWhere('p.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('p.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?PlanCollage
    //    {
    //        return $this->createQueryBuilder('p')
    //            ->andWhere('p.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
