<?php

namespace App\Repository;

use App\Entity\ParametrageBancJour;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<ParametrageBancJour>
 */
class ParametrageBancJourRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ParametrageBancJour::class);
    }

    public function findDatesValideesPourBanc(int $bancId): array
    {
        $qb = $this->createQueryBuilder('p')
            ->select('DISTINCT p.date')
            ->where('p.banc = :bancId')
            ->andWhere('p.parametrageValide = true')
            ->setParameter('bancId', $bancId)
            ->orderBy('p.date', 'ASC');

        $results = $qb->getQuery()->getResult();

        // On retourne un tableau de chaînes au format Y-m-d
        return array_map(fn($row) => $row['date']->format('Y-m-d'), $results);
    }

    public function findBancsValidesPourDate(string $date): array
    {
        return $this->getEntityManager()
            ->createQuery(
                'SELECT b
                FROM App\Entity\Banc b
                JOIN b.parametrageBancJours p
                WHERE p.date = :date
                AND p.parametrageValide = true
                ORDER BY b.designation ASC'
            )
            ->setParameter('date', new \DateTime($date))
            ->getResult();
    }

    public function findHorairesValidesPourBancEtDate(int $bancId, \DateTimeInterface $date): array
    {
        $pbj = $this->createQueryBuilder('p')
            ->where('p.banc = :bancId')
            ->andWhere('p.date = :date')
            ->andWhere('p.parametrageValide = true')
            ->setParameter('bancId', $bancId)
            ->setParameter('date', $date)
            ->getQuery()
            ->getOneOrNullResult();

        if (!$pbj || $pbj->getNbCollageParJour() < 1) {
            return [];
        }

        // Exemple : créneaux toutes les 4h à partir de 8h
        $nb = $pbj->getNbCollageParJour();
        $start = new \DateTime('08:00');
        $horaires = [];

        for ($i = 0; $i < $nb; $i++) {
            $h = (clone $start)->modify("+".($i * 4)." hours");
            $horaires[] = $h->format('H:i');
        }

        return $horaires;
}


    //    /**
    //     * @return ParametrageBancJour[] Returns an array of ParametrageBancJour objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('p')
    //            ->andWhere('p.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('p.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?ParametrageBancJour
    //    {
    //        return $this->createQueryBuilder('p')
    //            ->andWhere('p.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
