<?php

namespace App\Repository;

use App\Entity\User;
use App\Entity\Heure;
use DateTimeInterface;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;

/**
 * @extends ServiceEntityRepository<Heure>
 */
class HeureRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Heure::class);
    }
    public function findByUserAndDate(User $user, \DateTimeInterface $date): array
    {
        $start = (new \DateTime())->setTimestamp($date->getTimestamp())->setTime(0, 0, 0);
        $end = (new \DateTime())->setTimestamp($date->getTimestamp())->setTime(23, 59, 59);

        return $this->createQueryBuilder('h')
            ->andWhere('h.user = :user')
            ->andWhere('h.date BETWEEN :start AND :end')
            ->setParameter('user', $user)
            ->setParameter('start', $start)
            ->setParameter('end', $end)
            ->orderBy('h.heureDebut', 'ASC')
            ->getQuery()
            ->getResult();
    }

    //    /**
    //     * @return Heure[] Returns an array of Heure objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('h')
    //            ->andWhere('h.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('h.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?Heure
    //    {
    //        return $this->createQueryBuilder('h')
    //            ->andWhere('h.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
