<?php

namespace App\Repository;

use App\Entity\Affaire;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;

/**
 * @extends ServiceEntityRepository<Affaire>
 */
class AffaireRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Affaire::class);
    }
    /**
     * @return [type]
     */
    public function getListeAffaires() {

        $query = $this->createQueryBuilder('a')
            ->where('a.dateDelete is NULL')            
        ;
        
        return $query->getQuery()->getResult();
    }

    public function findByNomChantierEtFichier(string $nomChantier, string $nomFichier): ?Affaire
    {
        return $this->createQueryBuilder('a')
            ->where('a.nomChantier = :nomChantier')
            ->andWhere('a.nomFichiersExcel = :nomFichier')
            ->setParameter('nomChantier', $nomChantier)
            ->setParameter('nomFichier', $nomFichier)
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }

    // STATS PAR AFFAIRE
    public function getStatsPoutresParAffaire(EntityManagerInterface $em): array
    {
        $today = new \DateTimeImmutable();

        $qb = $em->createQueryBuilder();

        $qb->select('a.id AS affaire_id', 'a.nomChantier AS affaire_nom')
            ->addSelect('COUNT(da.id) AS totalPoutres')

            ->addSelect('(SELECT COUNT(pp1.id)
                        FROM App\Entity\PoutrePosition pp1
                        JOIN pp1.poutre da1
                        WHERE da1.affaire = a) AS dansPlan')

            ->addSelect('(SELECT COUNT(pp2.id)
                        FROM App\Entity\PoutrePosition pp2
                        JOIN pp2.poutre da2
                        JOIN pp2.plan pc2
                        WHERE pc2.valide = true AND da2.affaire = a) AS dansPlanValide')

            ->addSelect('(SELECT COUNT(pp3.id)
                        FROM App\Entity\PoutrePosition pp3
                        JOIN pp3.poutre da3
                        JOIN pp3.plan pc3
                        WHERE pc3.valide = true AND pc3.dateCollage < :today AND da3.affaire = a) AS dejaCollees')

            ->from('App\Entity\Affaire', 'a')
            ->leftJoin('a.detailAffaire', 'da') // OneToMany Affaire → DetailAffaire
            ->groupBy('a.id')
            ->setParameter('today', $today);

        return $qb->getQuery()->getResult();
    }


    //    /**
    //     * @return Affaire[] Returns an array of Affaire objects
    //     */
    //    public function findByExampleField($value): array
    //    {
    //        return $this->createQueryBuilder('a')
    //            ->andWhere('a.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->orderBy('a.id', 'ASC')
    //            ->setMaxResults(10)
    //            ->getQuery()
    //            ->getResult()
    //        ;
    //    }

    //    public function findOneBySomeField($value): ?Affaire
    //    {
    //        return $this->createQueryBuilder('a')
    //            ->andWhere('a.exampleField = :val')
    //            ->setParameter('val', $value)
    //            ->getQuery()
    //            ->getOneOrNullResult()
    //        ;
    //    }
}
