<?php

namespace App\Form;

use App\Entity\User;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class UserTypeForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email')            
            ->add('password')            
            ->add('nom')
            ->add('prenom')
            ->add('matricule')
            ->add('manager', EntityType::class, [
                'class' => User::class,
                'required' => false,
                'choice_label' => fn($u) => $u->getNomComplet(),
                'label' => 'Manager',
            ])
            ->add('roles', ChoiceType::class, [
                'label' => 'Rôle',
                'choices' => [
                    'Salarié' => 'ROLE_SALARIE',
                    'Manager' => 'ROLE_MANAGER',
                    'Prod LC' => 'ROLE_PROD',
                    'Admin' => 'ROLE_ADMIN',
                ],
                'multiple' => true,
                'expanded' => true,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }
}
