<?php
// src/Form/PlanSearchType.php
namespace App\Form;

use App\Entity\Banc;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;

class PlanSearchType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('banc', EntityType::class, [
                'class' => Banc::class,
                'choice_label' => 'designation',
                'placeholder' => 'Choisir un banc',
            ])
            ->add('dateCollage', DateType::class, [
                'widget' => 'single_text',
                'html5' => false,
                'attr' => ['class' => 'js-datepicker'],
            ])
           ->add('heureCollage', TimeType::class, [
                'widget' => 'single_text',
                'data' => new \DateTimeImmutable('08:00')
           ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'csrf_protection' => true,
        ]);
    }
}