<?php

namespace App\Form;

use App\Entity\User;
use App\Entity\Heure;
use App\Entity\Tache;
use App\Entity\Affaire;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class HeureTypeForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('date')
            ->add('heureDebut')
            ->add('heureFin')
            ->add('tache', EntityType::class, [
                'class' => Tache::class,
                'choice_label' => 'nom',
                'group_by' => function (Tache $tache) {
                    return $tache->getCategorieTache() ? $tache->getCategorieTache()->getNom() : 'Autres';
                },
                'placeholder' => 'Sélectionnez une tâche',
                'required' => true,
            ])
            ->add('typeHeure')
            ->add('secteur')        
            ->add('commentaire')
            ->add('affaire', EntityType::class, [
                'class' => Affaire::class,
                'choice_label' => 'nomChantier',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Heure::class,
        ]);
    }
}
