<?php

namespace App\Form;

use App\Entity\Banc;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

class BancType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('designation')
            ->add('longueurMax')
            ->add('largeurMax')
            ->add('droit', CheckboxType::class, [
                'required' => false,
                'label' => 'Banc droit'
            ])
            ->add('ctf', CheckboxType::class, [
                'required' => false,
                'label' => 'Contre flêche'
            ])
            ->add('hydraulique', CheckboxType::class, [
                'required' => false,
                'label' => 'Banc hydraulique'
            ])
            ->add('epaisseurMax')
            ->add('nombreCouche')
            ->add('epure', CheckboxType::class, [
                'required' => false,
                'label' => 'Courbe'
            ])
            ->add('tempsCollage', null, [
                'widget' => 'single_text',
            ])
            ->add('tempsSerrage', null, [
                'widget' => 'single_text',
            ])
            ->add('rangee', null, [
                'label'=> 'Emplacement Rangée N°'
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Banc::class,
        ]);
    }
}
