<?php

namespace App\Form;

use App\Entity\Affaire;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;

class AffaireType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nomChantier')
            ->add('dateMiseDispo', DateTimeType::class, [
                    'label' => 'Date de mise à Disposition',
                    'widget' => 'single_text',
                    "format" => 'dd-MM-yyyy',
                    'required' => false,
                    // prevents rendering it as type="date", to avoid HTML5 date pickers
                    'html5' => false,
                    'attr' => ['class' => 'form-control input-group date datepicker'],
                ])
            ->add('numeroSemainePlanification')     
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Affaire::class,
        ]);
    }
}
