<?php

namespace App\Entity;

use App\Repository\TacheRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TacheRepository::class)]
class Tache
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 100)]
    private ?string $nom = null;

    #[ORM\ManyToOne(inversedBy: 'taches')]
    private ?CategorieTache $CategorieTache = null;

    /**
     * @var Collection<int, Heure>
     */
    #[ORM\OneToMany(targetEntity: Heure::class, mappedBy: 'tache')]
    private Collection $heures;

    public function __construct()
    {
        $this->heures = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): static
    {
        $this->nom = $nom;

        return $this;
    }

    public function getCategorieTache(): ?CategorieTache
    {
        return $this->CategorieTache;
    }

    public function setCategorieTache(?CategorieTache $CategorieTache): static
    {
        $this->CategorieTache = $CategorieTache;

        return $this;
    }

    /**
     * @return Collection<int, Heure>
     */
    public function getHeures(): Collection
    {
        return $this->heures;
    }

    public function addHeure(Heure $heure): static
    {
        if (!$this->heures->contains($heure)) {
            $this->heures->add($heure);
            $heure->setTache($this);
        }

        return $this;
    }

    public function removeHeure(Heure $heure): static
    {
        if ($this->heures->removeElement($heure)) {
            // set the owning side to null (unless already changed)
            if ($heure->getTache() === $this) {
                $heure->setTache(null);
            }
        }

        return $this;
    }
}
