<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;

#[ORM\Entity()]

class Regroupement
{
    #[ORM\Id, ORM\GeneratedValue, ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: 'float')]
    private float $longueurTotale;

    #[ORM\ManyToMany(targetEntity: DetailAffaire::class, inversedBy: 'regroupements')]
    #[ORM\JoinTable(name: 'regroupement_poutre')]
    private Collection $poutres;

    #[ORM\ManyToOne(inversedBy: 'regroupements')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Affaire $affaire = null;

    #[ORM\Column(type: 'float')]
    private float $volumeTotal;

    #[ORM\Column(type: 'integer')]
    private int $quantite = 1;

    #[ORM\Column(type: 'integer')]
    private int $longueurFinale;

    public function __construct()
    {
        $this->poutres = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLongueurTotale(): float
    {
        return $this->longueurTotale;
    }

    public function setLongueurTotale(float $longueur): self
    {
        $this->longueurTotale = $longueur;
        return $this;
    }

    public function getPoutres(): Collection
    {
        return $this->poutres;
    }

    public function addPoutre(DetailAffaire $poutre): self
    {
        if (!$this->poutres->contains($poutre)) {
            $this->poutres[] = $poutre;
        }
        return $this;
    }

    public function removePoutre(DetailAffaire $poutre): self
    {
        $this->poutres->removeElement($poutre);
        return $this;
    }

    public function getAffaire(): ?affaire
    {
        return $this->affaire;
    }

    public function setAffaire(?Affaire $affaire): static
    {
        $this->affaire = $affaire;

        return $this;
    }

    /**
     * Get the value of volumeTotal
     */ 
    public function getVolumeTotal()
    {
        return $this->volumeTotal;
    }

    /**
     * Set the value of volumeTotal
     *
     * @return  self
     */ 
    public function setVolumeTotal($volumeTotal)
    {
        $this->volumeTotal = $volumeTotal;

        return $this;
    }

    /**
     * Get the value of quantite
     */ 
    public function getQuantite()
    {
        return $this->quantite;
    }

    /**
     * Set the value of quantite
     *
     * @return  self
     */ 
    public function setQuantite($quantite)
    {
        $this->quantite = $quantite;

        return $this;
    }

    /**
     * Get the value of longueurFinale
     */ 
    public function getLongueurFinale()
    {
        return $this->longueurFinale;
    }

    /**
     * Set the value of longueurFinale
     *
     * @return  self
     */ 
    public function setLongueurFinale($longueurFinale)
    {
        $this->longueurFinale = $longueurFinale;

        return $this;
    }
}