<?php

namespace App\Entity;

use App\Repository\PoutreStockRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PoutreStockRepository::class)]
class PoutreStock
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?int $longueur = null;

    #[ORM\Column]
    private ?int $largeur = null;

    #[ORM\Column(length: 20)]
    private ?string $couche = null;

    #[ORM\Column(nullable: true)]
    private ?float $positionLeft = null;

    #[ORM\Column(nullable: true)]
    private ?float $positionTop = null;

    #[ORM\Column(type: 'datetime_immutable')]
    private \DateTimeImmutable $dateCollage;

    #[ORM\Column(nullable: true)]
    private ?int $bancId = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $designation = null;

    #[ORM\ManyToOne(inversedBy: 'poutreStocks')]
    private ?PlanCollage $planCollage = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLongueur(): ?int
    {
        return $this->longueur;
    }

    public function setLongueur(int $longueur): static
    {
        $this->longueur = $longueur;

        return $this;
    }

    public function getLargeur(): ?int
    {
        return $this->largeur;
    }

    public function setLargeur(int $largeur): static
    {
        $this->largeur = $largeur;

        return $this;
    }

    public function getCouche(): ?string
    {
        return $this->couche;
    }

    public function setCouche(string $couche): static
    {
        $this->couche = $couche;

        return $this;
    }

    public function getPositionLeft(): ?float
    {
        return $this->positionLeft;
    }

    public function setPositionLeft(?float $positionLeft): static
    {
        $this->positionLeft = $positionLeft;

        return $this;
    }

    public function getPositionTop(): ?float
    {
        return $this->positionTop;
    }

    public function setPositionTop(?float $positionTop): static
    {
        $this->positionTop = $positionTop;

        return $this;
    }

    public function getBancId(): ?int
    {
        return $this->bancId;
    }

    public function setBancId(?int $bancId): static
    {
        $this->bancId = $bancId;

        return $this;
    }

    public function getDesignation(): ?string
    {
        return $this->designation;
    }

    public function setDesignation(?string $designation): static
    {
        $this->designation = $designation;

        return $this;
    }

    /**
     * Get the value of dateCollage
     */ 
    public function getDateCollage()
    {
        return $this->dateCollage;
    }

    /**
     * Set the value of dateCollage
     *
     * @return  self
     */ 
    public function setDateCollage($dateCollage)
    {
        $this->dateCollage = $dateCollage;

        return $this;
    }

    public function getPlanCollage(): ?PlanCollage
    {
        return $this->planCollage;
    }

    public function setPlanCollage(?PlanCollage $planCollage): static
    {
        $this->planCollage = $planCollage;

        return $this;
    }
}
