<?php

namespace App\Entity;

use App\Repository\PoutrePositionRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PoutrePositionRepository::class)]
class PoutrePosition
{
    // ────────────────────────────────
    // PROPRIÉTÉS
    // ────────────────────────────────

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    /** Id réel de la poutre dans la table des poutres (pas la position) */
    #[ORM\Column(type: 'integer')]
    private int $poutreId;

    /** Couche : 'sup' ou 'inf' */
    #[ORM\Column(length: 10)]
    private string $couche;

    /** Position horizontale (mm à partir du bord gauche du banc) */
    #[ORM\Column]
    private int $leftMm;

    /** Position verticale (mm à partir du haut du banc) */
    #[ORM\Column]
    private int $topMm;

    /** Plan de collage parent */
    #[ORM\ManyToOne(inversedBy: 'positions')]
    #[ORM\JoinColumn(nullable: false)]
    private ?PlanCollage $plan = null;

    #[ORM\ManyToOne(targetEntity: DetailAffaire::class)]
    #[ORM\JoinColumn(nullable: false)]
    private ?DetailAffaire $poutre = null;

    #[ORM\Column(type: 'string', nullable: true)]
    private ?string $regroupementId = null;

    #[ORM\Column(type: 'float')]
    private float $largeur;

    #[ORM\Column(type: 'float')]
    private float $longueur;

    #[ORM\Column(nullable: true)]
    private ?int $numeroSerie = null;

    #[ORM\Column(type: 'integer', nullable: true)]
    private ?int $ordreAffichage = null;

    // ────────────────────────────────
    // GETTERS / SETTERS
    // ────────────────────────────────

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPoutreId(): int
    {
        return $this->poutreId;
    }

    public function setPoutreId(int $poutreId): self
    {
        $this->poutreId = $poutreId;
        return $this;
    }

    public function getCouche(): string
    {
        return $this->couche;
    }

    public function setCouche(string $couche): self
    {
        $this->couche = $couche;
        return $this;
    }

    public function getLeftMm(): int
    {
        return $this->leftMm;
    }

    public function setLeftMm(int $leftMm): self
    {
        $this->leftMm = $leftMm;
        return $this;
    }

    public function getTopMm(): int
    {
        return $this->topMm;
    }

    public function setTopMm(int $topMm): self
    {
        $this->topMm = $topMm;
        return $this;
    }

    public function getPlan(): ?PlanCollage
    {
        return $this->plan;
    }

    public function setPlan(?PlanCollage $plan): self
    {
        $this->plan = $plan;
        return $this;
    }

    public function getPoutre(): ?DetailAffaire
    {
        return $this->poutre;
    }

    public function setPoutre(?DetailAffaire $poutre): self
    {
        $this->poutre = $poutre;
        return $this;
    }
    public function getRegroupementId(): ?string
    {
        return $this->regroupementId;
    }

    public function setRegroupementId(?string $regroupementId): self
    {
        $this->regroupementId = $regroupementId;
        return $this;
    }
    public function getLargeur(): float { return $this->largeur; }
    public function setLargeur(float $largeur): self { $this->largeur = $largeur; return $this; }

    public function getLongueur(): float { return $this->longueur; }
    public function setLongueur(float $longueur): self { $this->longueur = $longueur; return $this; }

    public function getNumeroSerie(): ?int
    {
        return $this->numeroSerie;
    }

    public function setNumeroSerie(?int $numeroSerie): static
    {
        $this->numeroSerie = $numeroSerie;

        return $this;
    }
    public function getOrdreAffichage(): ?int
    {
        return $this->ordreAffichage;
    }

    public function setOrdreAffichage(?int $ordre): self
    {
        $this->ordreAffichage = $ordre;
        return $this;
    }

}
