<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use App\Repository\PlanCollageRepository;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;

#[ORM\Entity(repositoryClass: PlanCollageRepository::class)]
class PlanCollage
{
   // ────────────────────────────────
    // PROPRIÉTÉS
    // ────────────────────────────────

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    /** Date (journée) de réalisation du collage */
    #[ORM\Column(type: 'datetime_immutable')]
    private \DateTimeImmutable $dateCollage;

    /** Poutres positionnées (1-n) */
    #[ORM\OneToMany(mappedBy: 'plan', targetEntity: PoutrePosition::class,
                    cascade: ['persist', 'remove'], orphanRemoval: true)]
    private Collection $positions;

    #[ORM\ManyToOne(targetEntity: Banc::class)]
    #[ORM\JoinColumn(nullable: false)]
    private ?Banc $banc = null;

    #[ORM\Column(type: 'time')]
    private ?\DateTimeInterface $heureCollage = null;

    #[ORM\Column(nullable: true)]
    private ?bool $valide = null;

    #[ORM\Column(nullable: true)]
    private ?int $longueurBanc = null;

    #[ORM\Column(nullable: true)]
    private ?int $largeurBanc = null;

    /**
     * @var Collection<int, PoutreStock>
     */
    #[ORM\OneToMany(targetEntity: PoutreStock::class, mappedBy: 'planCollage')]
    private Collection $poutreStocks;

    public function __construct()
    {
        $this->positions = new ArrayCollection();
        $this->heureCollage = new \DateTimeImmutable('08:00');
        $this->poutreStocks = new ArrayCollection();
    }

    // ────────────────────────────────
    // GETTERS / SETTERS
    // ────────────────────────────────

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateCollage(): \DateTimeImmutable
    {
        return $this->dateCollage;
    }

    public function setDateCollage(\DateTimeImmutable $dateCollage): self
    {
        $this->dateCollage = $dateCollage;
        return $this;
    }

    /**
     * @return Collection<int, PoutrePosition>
     */
    public function getPositions(): Collection
    {
        return $this->positions;
    }

    public function addPosition(PoutrePosition $position): self
    {
        if (!$this->positions->contains($position)) {
            $this->positions->add($position);
            $position->setPlan($this);
        }
        return $this;
    }

    public function removePosition(PoutrePosition $position): self
    {
        if ($this->positions->removeElement($position)) {
            // mettre à null le lien inverse (si besoin)
            if ($position->getPlan() === $this) {
                $position->setPlan(null);
            }
        }
        return $this;
    }

    public function getBanc(): ?Banc
    {
        return $this->banc;
    }

    public function setBanc(?Banc $banc): self
    {
        $this->banc = $banc;
        return $this;
    }
    
    public function getHeureCollage(): ?\DateTimeInterface
    {
        return $this->heureCollage;
    }

    public function setHeureCollage(\DateTimeInterface $heure): self
    {
        $this->heureCollage = $heure;
        return $this;
    }

    public function isValide(): ?bool
    {
        return $this->valide;
    }

    public function setValide(?bool $valide): static
    {
        $this->valide = $valide;

        return $this;
    }

    public function getLongueurBanc(): ?int
    {
        return $this->longueurBanc;
    }

    public function setLongueurBanc(?int $longueurBanc): static
    {
        $this->longueurBanc = $longueurBanc;

        return $this;
    }

    public function getLargeurBanc(): ?int
    {
        return $this->largeurBanc;
    }

    public function setLargeurBanc(?int $largeurBanc): static
    {
        $this->largeurBanc = $largeurBanc;

        return $this;
    }

    /**
     * @return Collection<int, PoutreStock>
     */
    public function getPoutreStocks(): Collection
    {
        return $this->poutreStocks;
    }

    public function addPoutreStock(PoutreStock $poutreStock): static
    {
        if (!$this->poutreStocks->contains($poutreStock)) {
            $this->poutreStocks->add($poutreStock);
            $poutreStock->setPlanCollage($this);
        }

        return $this;
    }

    public function removePoutreStock(PoutreStock $poutreStock): static
    {
        if ($this->poutreStocks->removeElement($poutreStock)) {
            // set the owning side to null (unless already changed)
            if ($poutreStock->getPlanCollage() === $this) {
                $poutreStock->setPlanCollage(null);
            }
        }

        return $this;
    }

}
