<?php 
namespace App\Entity;

use App\Repository\ParametrageBancJourRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ParametrageBancJourRepository::class)]
class ParametrageBancJour
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: "integer")]
    private ?int $id = null;

    #[ORM\ManyToOne(targetEntity: Banc::class)]
    #[ORM\JoinColumn(nullable: false)]
    private ?Banc $banc = null;

    #[ORM\Column(type: "date")]
    private ?\DateTimeInterface $date = null;

    #[ORM\Column(type: "boolean")]
    private bool $indisponible = false;

    #[ORM\Column(type: "boolean")]
    private bool $parametrageValide = false;

    #[ORM\Column(type: "text", nullable: true)]
    private ?string $remarque = null;

    #[ORM\Column(type: "datetime")]
    private ?\DateTimeInterface $dateCreate = null;

    #[ORM\Column(type: "datetime")]
    private ?\DateTimeInterface $dateUpdate = null;

    #[ORM\Column(type: "float", nullable: true)]
    private ?float $longueur = null;

    #[ORM\Column(type: "float", nullable: true)]
    private ?float $largeurMax = null;

    #[ORM\Column(type: "float", nullable: true)]
    private ?float $epaisseurMax = null;

    #[ORM\Column(type: "integer", nullable: true)]
    private ?int $nombreCouche = null;

    #[ORM\Column(type: "integer", nullable: true)]
    private ?int $nombreCollageJour = null;

    #[ORM\Column(type: "boolean")]
    private bool $epure = false;

    #[ORM\Column(type: "time", nullable: true)]
    private ?\DateTimeInterface $tempsCollage = null;

    #[ORM\Column(type: "time", nullable: true)]
    private ?\DateTimeInterface $tempsSerrage = null;

    // --- Getters / Setters ---

    public function getId(): ?int { return $this->id; }

    public function getBanc(): ?Banc { return $this->banc; }
    public function setBanc(?Banc $banc): self { $this->banc = $banc; return $this; }

    public function getDate(): ?\DateTimeInterface { return $this->date; }
    public function setDate(\DateTimeInterface $date): self { $this->date = $date; return $this; }

    public function isIndisponible(): bool { return $this->indisponible; }
    public function setIndisponible(bool $indisponible): self { $this->indisponible = $indisponible; return $this; }

    public function isParametrageValide(): bool { return $this->parametrageValide; }
    public function setParametrageValide(bool $parametrageValide): self { $this->parametrageValide = $parametrageValide; return $this; }

    public function getRemarque(): ?string { return $this->remarque; }
    public function setRemarque(?string $remarque): self { $this->remarque = $remarque; return $this; }

    public function getDateCreate(): ?\DateTimeInterface { return $this->dateCreate; }
    public function setDateCreate(\DateTimeInterface $dateCreate): self { $this->dateCreate = $dateCreate; return $this; }

    public function getDateUpdate(): ?\DateTimeInterface { return $this->dateUpdate; }
    public function setDateUpdate(\DateTimeInterface $dateUpdate): self { $this->dateUpdate = $dateUpdate; return $this; }

    /**
     * Get the value of longueur
     */ 
    public function getLongueur()
    {
        return $this->longueur;
    }

    /**
     * Set the value of longueur
     *
     * @return  self
     */ 
    public function setLongueur($longueur)
    {
        $this->longueur = $longueur;

        return $this;
    }

    /**
     * Get the value of largeurMax
     */ 
    public function getLargeurMax()
    {
        return $this->largeurMax;
    }

    /**
     * Set the value of largeurMax
     *
     * @return  self
     */ 
    public function setLargeurMax($largeurMax)
    {
        $this->largeurMax = $largeurMax;

        return $this;
    }

    /**
     * Get the value of epaisseurMax
     */ 
    public function getEpaisseurMax()
    {
        return $this->epaisseurMax;
    }

    /**
     * Set the value of epaisseurMax
     *
     * @return  self
     */ 
    public function setEpaisseurMax($epaisseurMax)
    {
        $this->epaisseurMax = $epaisseurMax;

        return $this;
    }

    /**
     * Get the value of nombreCouche
     */ 
    public function getNombreCouche()
    {
        return $this->nombreCouche;
    }

    /**
     * Set the value of nombreCouche
     *
     * @return  self
     */ 
    public function setNombreCouche($nombreCouche)
    {
        $this->nombreCouche = $nombreCouche;

        return $this;
    }

    /**
     * Get the value of nombreCollageJour
     */ 
    public function getNombreCollageJour()
    {
        return $this->nombreCollageJour;
    }

    /**
     * Set the value of nombreCollageJour
     *
     * @return  self
     */ 
    public function setNombreCollageJour($nombreCollageJour)
    {
        $this->nombreCollageJour = $nombreCollageJour;

        return $this;
    }

    /**
     * Get the value of epure
     */ 
    public function getEpure()
    {
        return $this->epure;
    }
    public function isEpure(): bool { return $this->epure; }
    /**
     * Set the value of epure
     *
     * @return  self
     */ 
    public function setEpure($epure)
    {
        $this->epure = $epure;

        return $this;
    }

    /**
     * Get the value of tempsCollage
     */ 
    public function getTempsCollage()
    {
        return $this->tempsCollage;
    }

    /**
     * Set the value of tempsCollage
     *
     * @return  self
     */ 
    public function setTempsCollage($tempsCollage)
    {
        $this->tempsCollage = $tempsCollage;

        return $this;
    }

    /**
     * Get the value of tempsSerrage
     */ 
    public function getTempsSerrage()
    {
        return $this->tempsSerrage;
    }

    /**
     * Set the value of tempsSerrage
     *
     * @return  self
     */ 
    public function setTempsSerrage($tempsSerrage)
    {
        $this->tempsSerrage = $tempsSerrage;

        return $this;
    }
}
