<?php 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use App\Repository\NumeroSerieRepository;

#[ORM\Entity(repositoryClass: NumeroSerieRepository::class)]
class NumeroSerie
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    private ?int $id = null;

    #[ORM\Column(type: 'integer')]
    private int $dernierNumero = 1;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDernierNumero(): int
    {
        return $this->dernierNumero;
    }

    public function setDernierNumero(int $numero): self
    {
        $this->dernierNumero = $numero;
        return $this;
    }

    public function incrementer(): int
    {
        return ++$this->dernierNumero;
    }
}
