<?php

namespace App\Entity;

use App\Repository\HeureRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: HeureRepository::class)]
class Heure
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'heures')]
    #[ORM\JoinColumn(nullable: false)]
    private ?User $user = null;

    #[ORM\ManyToOne(inversedBy: 'heures')]
    private ?Affaire $affaire = null;

    #[ORM\Column]
    private ?\DateTime $date = null;

    #[ORM\Column]
    private ?\DateTime $heureDebut = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTime $heureFin = null;

    #[ORM\Column(length: 30, nullable: true)]
    private ?string $typeHeure = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $secteur = null;

    #[ORM\Column(nullable: true)]
    private ?bool $modifieParManager = null;

    #[ORM\Column(nullable: true)]
    private ?bool $badgeAuto = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $commentaire = null;

    #[ORM\ManyToOne(inversedBy: 'heures')]
    private ?Tache $tache = null;

    
    // public function __toString(): string
    // {
    //     //return $this->nom;
    // }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): static
    {
        $this->user = $user;

        return $this;
    }

    public function getAffaire(): ?Affaire
    {
        return $this->affaire;
    }

    public function setAffaire(?Affaire $affaire): static
    {
        $this->affaire = $affaire;

        return $this;
    }

    public function getDate(): ?\DateTime
    {
        return $this->date;
    }

    public function setDate(\DateTime $date): static
    {
        $this->date = $date;

        return $this;
    }

    public function getHeureDebut(): ?\DateTime
    {
        return $this->heureDebut;
    }

    public function setHeureDebut(\DateTime $heureDebut): static
    {
        $this->heureDebut = $heureDebut;

        return $this;
    }

    public function getHeureFin(): ?\DateTime
    {
        return $this->heureFin;
    }

    public function setHeureFin(?\DateTime $heureFin): static
    {
        $this->heureFin = $heureFin;

        return $this;
    }


    public function getTypeHeure(): ?string
    {
        return $this->typeHeure;
    }

    public function setTypeHeure(?string $typeHeure): static
    {
        $this->typeHeure = $typeHeure;

        return $this;
    }

    public function getSecteur(): ?string
    {
        return $this->secteur;
    }

    public function setSecteur(?string $secteur): static
    {
        $this->secteur = $secteur;

        return $this;
    }

    public function isModifieParManager(): ?bool
    {
        return $this->modifieParManager;
    }

    public function setModifieParManager(?bool $modifieParManager): static
    {
        $this->modifieParManager = $modifieParManager;

        return $this;
    }

    public function isBadgeAuto(): ?bool
    {
        return $this->badgeAuto;
    }

    public function setBadgeAuto(?bool $badgeAuto): static
    {
        $this->badgeAuto = $badgeAuto;

        return $this;
    }

    public function getCommentaire(): ?string
    {
        return $this->commentaire;
    }

    public function setCommentaire(?string $commentaire): static
    {
        $this->commentaire = $commentaire;

        return $this;
    }

    public function getTache(): ?Tache
    {
        return $this->tache;
    }

    public function setTache(?Tache $tache): static
    {
        $this->tache = $tache;

        return $this;
    }

    
}
