<?php

namespace App\Entity;

use App\Entity\Regroupement;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\DetailAffaireRepository;
use Doctrine\Common\Collections\Collection;

#[ORM\Entity(repositoryClass: DetailAffaireRepository::class)]
class DetailAffaire
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;
    
    #[ORM\ManyToMany(targetEntity: Regroupement::class, mappedBy: 'poutres')]
    private Collection $regroupements;

    #[ORM\Column]
    private ?int $nbPiece = null;

    #[ORM\Column(length: 5, nullable: true)]
    private ?string $usinage = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $designation = null;

    #[ORM\Column(nullable: true)]
    private ?int $ref = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $ctf = null;

    #[ORM\Column(nullable: true)]
    private ?int $sectionLargeur = null;

    #[ORM\Column(nullable: true)]
    private ?int $sectionHauteur = null;

    #[ORM\Column(nullable: true)]
    private ?int $longueurArrondie = null;

    #[ORM\Column(nullable: true)]
    private ?bool $droit = null;

    #[ORM\Column(nullable: true)]
    private ?bool $lamelisation = null;

    #[ORM\Column(nullable: true)]
    private ?int $longueurProduction = null;

    #[ORM\Column(nullable: true)]
    private ?int $sectionLameLargeur = null;

    #[ORM\Column(nullable: true)]
    private ?int $sectionLameHauteur = null;

    #[ORM\Column(nullable: true)]
    private ?int $epaisseurRabotee = null;

    #[ORM\Column(nullable: true)]
    private ?int $nbLame = null;

    #[ORM\Column(nullable: true)]
    private ?int $longueurLameAboutee = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 3, nullable: true)]
    private ?string $volumefini = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $remarque = null;

    #[ORM\Column(nullable: true)]
    private ?bool $tac = null;

    #[ORM\Column(nullable: true)]
    private ?bool $gl28h = null;

    #[ORM\Column(nullable: true)]
    private ?bool $gl24h = null;

    #[ORM\Column(nullable: true)]
    private ?bool $glxxhsRefile = null;

    #[ORM\Column(nullable: true)]
    private ?bool $controleDimensionnel = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 3, nullable: true)]
    private ?string $volumeBoisAbouteNonRabote = null;

    #[ORM\Column(nullable: true)]
    private ?int $statut = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $dateCreate = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateUpdate = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateDelete = null;

    #[ORM\ManyToOne(targetEntity: Affaire::class, inversedBy: 'detailAffaire')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Affaire $affaire = null;



    #[ORM\Column(nullable: true)]
    private ?int $serie = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 3, nullable: true)]
    private ?string $longueurLameAbouteeTotal = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $bkgColor = null;
    
    private int $quantiteRestante = 0;

    public function getQuantiteRestante(): int
    {
        return $this->quantiteRestante;
    }
    public function setQuantiteRestante(int $val): self
    {
        $this->quantiteRestante = $val;
        return $this;
    }

    

    /**
     * Get the value of id
     */ 
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of id
     *
     * @return  self
     */ 
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of nbPiece
     */ 
    public function getNbPiece()
    {
        return $this->nbPiece;
    }

    /**
     * Set the value of nbPiece
     *
     * @return  self
     */ 
    public function setNbPiece($nbPiece)
    {
        $this->nbPiece = $nbPiece;

        return $this;
    }

    /**
     * Get the value of usinage
     */ 
    public function getUsinage()
    {
        return $this->usinage;
    }

    /**
     * Set the value of usinage
     *
     * @return  self
     */ 
    public function setUsinage($usinage)
    {
        $this->usinage = $usinage;

        return $this;
    }

    /**
     * Get the value of designation
     */ 
    public function getDesignation()
    {
        return $this->designation;
    }

    /**
     * Set the value of designation
     *
     * @return  self
     */ 
    public function setDesignation($designation)
    {
        $this->designation = $designation;

        return $this;
    }

    /**
     * Get the value of ref
     */ 
    public function getRef()
    {
        return $this->ref;
    }

    /**
     * Set the value of ref
     *
     * @return  self
     */ 
    public function setRef($ref)
    {
        $this->ref = $ref;

        return $this;
    }

    /**
     * Get the value of ctf
     */ 
    public function getCtf()
    {
        return $this->ctf;
    }

    /**
     * Set the value of ctf
     *
     * @return  self
     */ 
    public function setCtf($ctf)
    {
        $this->ctf = $ctf;

        return $this;
    }

    /**
     * Get the value of sectionLargeur
     */ 
    public function getSectionLargeur()
    {
        return $this->sectionLargeur;
    }

    /**
     * Set the value of sectionLargeur
     *
     * @return  self
     */ 
    public function setSectionLargeur($sectionLargeur)
    {
        $this->sectionLargeur = $sectionLargeur;

        return $this;
    }

    /**
     * Get the value of sectionHauteur
     */ 
    public function getSectionHauteur()
    {
        return $this->sectionHauteur;
    }

    /**
     * Set the value of sectionHauteur
     *
     * @return  self
     */ 
    public function setSectionHauteur($sectionHauteur)
    {
        $this->sectionHauteur = $sectionHauteur;

        return $this;
    }

    /**
     * Get the value of longueurArrondie
     */ 
    public function getLongueurArrondie()
    {
        return $this->longueurArrondie;
    }

    /**
     * Set the value of longueurArrondie
     *
     * @return  self
     */ 
    public function setLongueurArrondie($longueurArrondie)
    {
        $this->longueurArrondie = $longueurArrondie;

        return $this;
    }

    /**
     * Get the value of droit
     */ 
    public function getDroit()
    {
        return $this->droit;
    }

    /**
     * Set the value of droit
     *
     * @return  self
     */ 
    public function setDroit($droit)
    {
        $this->droit = $droit;

        return $this;
    }

    /**
     * Get the value of lamelisation
     */ 
    public function getLamelisation()
    {
        return $this->lamelisation;
    }

    /**
     * Set the value of lamelisation
     *
     * @return  self
     */ 
    public function setLamelisation($lamelisation)
    {
        $this->lamelisation = $lamelisation;

        return $this;
    }

    /**
     * Get the value of longueurProduction
     */ 
    public function getLongueurProduction()
    {
        return $this->longueurProduction;
    }

    /**
     * Set the value of longueurProduction
     *
     * @return  self
     */ 
    public function setLongueurProduction($longueurProduction)
    {
        $this->longueurProduction = $longueurProduction;

        return $this;
    }

    /**
     * Get the value of sectionLameLargeur
     */ 
    public function getSectionLameLargeur()
    {
        return $this->sectionLameLargeur;
    }

    /**
     * Set the value of sectionLameLargeur
     *
     * @return  self
     */ 
    public function setSectionLameLargeur($sectionLameLargeur)
    {
        $this->sectionLameLargeur = $sectionLameLargeur;

        return $this;
    }

    /**
     * Get the value of sectionLameHauteur
     */ 
    public function getSectionLameHauteur()
    {
        return $this->sectionLameHauteur;
    }

    /**
     * Set the value of sectionLameHauteur
     *
     * @return  self
     */ 
    public function setSectionLameHauteur($sectionLameHauteur)
    {
        $this->sectionLameHauteur = $sectionLameHauteur;

        return $this;
    }

    /**
     * Get the value of epaisseurRabotee
     */ 
    public function getEpaisseurRabotee()
    {
        return $this->epaisseurRabotee;
    }

    /**
     * Set the value of epaisseurRabotee
     *
     * @return  self
     */ 
    public function setEpaisseurRabotee($epaisseurRabotee)
    {
        $this->epaisseurRabotee = $epaisseurRabotee;

        return $this;
    }

    /**
     * Get the value of nbLame
     */ 
    public function getNbLame()
    {
        return $this->nbLame;
    }

    /**
     * Set the value of nbLame
     *
     * @return  self
     */ 
    public function setNbLame($nbLame)
    {
        $this->nbLame = $nbLame;

        return $this;
    }

    /**
     * Get the value of longueurLameAboutee
     */ 
    public function getLongueurLameAboutee()
    {
        return $this->longueurLameAboutee;
    }

    /**
     * Set the value of longueurLameAboutee
     *
     * @return  self
     */ 
    public function setLongueurLameAboutee($longueurLameAboutee)
    {
        $this->longueurLameAboutee = $longueurLameAboutee;

        return $this;
    }

    /**
     * Get the value of volumefini
     */ 
    public function getVolumefini()
    {
        return $this->volumefini;
    }

    /**
     * Set the value of volumefini
     *
     * @return  self
     */ 
    public function setVolumefini($volumefini)
    {
        $this->volumefini = $volumefini;

        return $this;
    }

    /**
     * Get the value of remarque
     */ 
    public function getRemarque()
    {
        return $this->remarque;
    }

    /**
     * Set the value of remarque
     *
     * @return  self
     */ 
    public function setRemarque($remarque)
    {
        $this->remarque = $remarque;

        return $this;
    }

    /**
     * Get the value of tac
     */ 
    public function getTac()
    {
        return $this->tac;
    }

    /**
     * Set the value of tac
     *
     * @return  self
     */ 
    public function setTac($tac)
    {
        $this->tac = $tac;

        return $this;
    }

    /**
     * Get the value of gl28h
     */ 
    public function getGl28h()
    {
        return $this->gl28h;
    }

    /**
     * Set the value of gl28h
     *
     * @return  self
     */ 
    public function setGl28h($gl28h)
    {
        $this->gl28h = $gl28h;

        return $this;
    }

    /**
     * Get the value of gl24h
     */ 
    public function getGl24h()
    {
        return $this->gl24h;
    }

    /**
     * Set the value of gl24h
     *
     * @return  self
     */ 
    public function setGl24h($gl24h)
    {
        $this->gl24h = $gl24h;

        return $this;
    }

    /**
     * Get the value of glxxhsRefile
     */ 
    public function getGlxxhsRefile()
    {
        return $this->glxxhsRefile;
    }

    /**
     * Set the value of glxxhsRefile
     *
     * @return  self
     */ 
    public function setGlxxhsRefile($glxxhsRefile)
    {
        $this->glxxhsRefile = $glxxhsRefile;

        return $this;
    }

    /**
     * Get the value of controleDimensionnel
     */ 
    public function getControleDimensionnel()
    {
        return $this->controleDimensionnel;
    }

    /**
     * Set the value of controleDimensionnel
     *
     * @return  self
     */ 
    public function setControleDimensionnel($controleDimensionnel)
    {
        $this->controleDimensionnel = $controleDimensionnel;

        return $this;
    }

    /**
     * Get the value of volumeBoisAbouteNonRabote
     */ 
    public function getVolumeBoisAbouteNonRabote()
    {
        return $this->volumeBoisAbouteNonRabote;
    }

    /**
     * Set the value of volumeBoisAbouteNonRabote
     *
     * @return  self
     */ 
    public function setVolumeBoisAbouteNonRabote($volumeBoisAbouteNonRabote)
    {
        $this->volumeBoisAbouteNonRabote = $volumeBoisAbouteNonRabote;

        return $this;
    }

    /**
     * Get the value of statut
     */ 
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set the value of statut
     *
     * @return  self
     */ 
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get the value of dateCreate
     */ 
    public function getDateCreate()
    {
        return $this->dateCreate;
    }

    /**
     * Set the value of dateCreate
     *
     * @return  self
     */ 
    public function setDateCreate($dateCreate)
    {
        $this->dateCreate = $dateCreate;

        return $this;
    }

    /**
     * Get the value of dateUpdate
     */ 
    public function getDateUpdate()
    {
        return $this->dateUpdate;
    }

    /**
     * Set the value of dateUpdate
     *
     * @return  self
     */ 
    public function setDateUpdate($dateUpdate)
    {
        $this->dateUpdate = $dateUpdate;

        return $this;
    }

    /**
     * Get the value of dateDelete
     */ 
    public function getDateDelete()
    {
        return $this->dateDelete;
    }

    /**
     * Set the value of dateDelete
     *
     * @return  self
     */ 
    public function setDateDelete($dateDelete)
    {
        $this->dateDelete = $dateDelete;

        return $this;
    }

    /**
     * Get the value of affaire
     */ 
    public function getAffaire()
    {
        return $this->affaire;
    }

    /**
     * Set the value of affaire
     *
     * @return  self
     */ 
    public function setAffaire($affaire)
    {
        $this->affaire = $affaire;

        return $this;
    }

    /**
     * Get the value of serie
     */ 
    public function getSerie()
    {
        return $this->serie;
    }

    /**
     * Set the value of serie
     *
     * @return  self
     */ 
    public function setSerie($serie)
    {
        $this->serie = $serie;

        return $this;
    }

    public function getLongueurLameAbouteeTotal(): ?string
    {
        return $this->longueurLameAbouteeTotal;
    }

    public function setLongueurLameAbouteeTotal(?string $longueurLameAbouteeTotal): static
    {
        $this->longueurLameAbouteeTotal = $longueurLameAbouteeTotal;

        return $this;
    }

    public function getBkgColor(): ?string
    {
        return $this->bkgColor;
    }

    public function setBkgColor(?string $bkgColor): static
    {
        $this->bkgColor = $bkgColor;

        return $this;
    }
    public function getRegroupements(): Collection
    {
        return $this->regroupements;
    }

    public function addRegroupement(Regroupement $regroupement): self
    {
        if (!$this->regroupements->contains($regroupement)) {
            $this->regroupements[] = $regroupement;
            $regroupement->addPoutre($this);
        }
        return $this;
    }
}
