<?php

namespace App\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\BancRepository;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;


#[ORM\Entity(repositoryClass: BancRepository::class)]
class Banc
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 100)]
    private ?string $designation = null;

    #[ORM\Column]
    private ?int $longueurMax = null;

    #[ORM\Column(nullable: true)]
    private ?bool $droit = null;

    #[ORM\Column(nullable: true)]
    private ?bool $ctf = null;

    #[ORM\Column(nullable: true)]
    private ?bool $hydraulique = null;

    #[ORM\Column(nullable: true)]
    private ?int $epaisseurMax = null;

    #[ORM\Column(nullable: true)]
    private ?int $nombreCouche = null;

    #[ORM\Column(nullable: true)]
    private ?bool $epure = null;

    #[ORM\Column(type: Types::TIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $tempsCollage = null;

    #[ORM\Column(type: Types::TIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $tempsSerrage = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $dateCreate = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateUpdate = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateDelete = null;

    /**
     * @var Collection<int, ParametrageBancJour>
     */
    #[ORM\OneToMany(targetEntity: ParametrageBancJour::class, mappedBy: 'banc')]
    private Collection $parametrageBancJours;

    #[ORM\Column]
    private ?int $rangee = null;

    #[ORM\Column(nullable: true)]
    private ?float $largeurMax = null;

    public function __construct()
    {
        $this->parametrageBancJours = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDesignation(): ?string
    {
        return $this->designation;
    }

    public function setDesignation(string $designation): static
    {
        $this->designation = $designation;

        return $this;
    }

    public function getLongueurMax(): ?int
    {
        return $this->longueurMax;
    }

    public function setLongueurMax(int $longueurMax): static
    {
        $this->longueurMax = $longueurMax;

        return $this;
    }

    public function isDroit(): ?bool
    {
        return $this->droit;
    }

    public function setDroit(?bool $droit): static
    {
        $this->droit = $droit;

        return $this;
    }

    public function isCtf(): ?bool
    {
        return $this->ctf;
    }

    public function setCtf(?bool $ctf): static
    {
        $this->ctf = $ctf;

        return $this;
    }

    public function isHydraulique(): ?bool
    {
        return $this->hydraulique;
    }

    public function setHydraulique(?bool $hydraulique): static
    {
        $this->hydraulique = $hydraulique;

        return $this;
    }

    public function getEpaisseurMax(): ?int
    {
        return $this->epaisseurMax;
    }

    public function setEpaisseurMax(?int $epaisseurMax): static
    {
        $this->epaisseurMax = $epaisseurMax;

        return $this;
    }

    public function getNombreCouche(): ?int
    {
        return $this->nombreCouche;
    }

    public function setNombreCouche(?int $nombreCouche): static
    {
        $this->nombreCouche = $nombreCouche;

        return $this;
    }

    public function isEpure(): ?bool
    {
        return $this->epure;
    }

    public function setEpure(?bool $epure): static
    {
        $this->epure = $epure;

        return $this;
    }

    public function getTempsCollage(): ?\DateTimeInterface
    {
        return $this->tempsCollage;
    }

    public function setTempsCollage(?\DateTimeInterface $tempsCollage): static
    {
        $this->tempsCollage = $tempsCollage;

        return $this;
    }

    public function getTempsSerrage(): ?\DateTimeInterface
    {
        return $this->tempsSerrage;
    }

    public function setTempsSerrage(?\DateTimeInterface $tempsSerrage): static
    {
        $this->tempsSerrage = $tempsSerrage;

        return $this;
    }

    public function getDateCreate(): ?\DateTimeInterface
    {
        return $this->dateCreate;
    }

    public function setDateCreate(\DateTimeInterface $dateCreate): static
    {
        $this->dateCreate = $dateCreate;

        return $this;
    }

    public function getDateUpdate(): ?\DateTimeInterface
    {
        return $this->dateUpdate;
    }

    public function setDateUpdate(?\DateTimeInterface $dateUpdate): static
    {
        $this->dateUpdate = $dateUpdate;

        return $this;
    }

    public function getDateDelete(): ?\DateTimeInterface
    {
        return $this->dateDelete;
    }

    public function setDateDelete(?\DateTimeInterface $dateDelete): static
    {
        $this->dateDelete = $dateDelete;

        return $this;
    }

    /**
     * @return Collection<int, ParametrageBancJour>
     */
    public function getParametrageBancJours(): Collection
    {
        return $this->parametrageBancJours;
    }

    public function addParametrageBancJour(ParametrageBancJour $parametrageBancJour): static
    {
        if (!$this->parametrageBancJours->contains($parametrageBancJour)) {
            $this->parametrageBancJours->add($parametrageBancJour);
            $parametrageBancJour->setBanc($this);
        }

        return $this;
    }

    public function removeParametrageBancJour(ParametrageBancJour $parametrageBancJour): static
    {
        if ($this->parametrageBancJours->removeElement($parametrageBancJour)) {
            // set the owning side to null (unless already changed)
            if ($parametrageBancJour->getBanc() === $this) {
                $parametrageBancJour->setBanc(null);
            }
        }

        return $this;
    }

    public function getRangee(): ?int
    {
        return $this->rangee;
    }

    public function setRangee(int $rangee): static
    {
        $this->rangee = $rangee;

        return $this;
    }

    public function getLargeurMax(): ?float
    {
        return $this->largeurMax;
    }

    public function setLargeurMax(?float $largeurMax): static
    {
        $this->largeurMax = $largeurMax;

        return $this;
    }
}
