<?php

namespace App\Entity;

use App\Repository\AffaireRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: AffaireRepository::class)]
class Affaire
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 15, nullable: true)]
    private ?string $client = null;

    #[ORM\Column(length: 100)]
    private ?string $nomChantier = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateFabrication = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateLivraison = null;

    #[ORM\Column(nullable: true)]
    private ?bool $assemblageAtelier = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $traitement = null;

    #[ORM\Column(nullable: true)]
    private ?bool $taillageTete = null;

    #[ORM\Column(nullable: true)]
    private ?bool $taillageRefilage = null;

    #[ORM\Column(nullable: true)]
    private ?bool $taillageDelardement = null;

    #[ORM\Column(length: 30, nullable: true)]
    private ?string $essence = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $colle = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $humidite = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentIndustriel = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentAgricole = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentSportif = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentEquestre = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentCulturel = null;

    #[ORM\Column(nullable: true)]
    private ?bool $batimentAutre = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $reference = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $adresseChantier = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $dateImport = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $dessinateur = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomFichiersExcel = null;

    /**
     * @var Collection<int, DetailAffaire>
     */
    #[ORM\OneToMany(targetEntity: DetailAffaire::class, mappedBy: 'affaire', orphanRemoval: true)]
    private Collection $detailAffaire;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateDelete = null;

    #[ORM\Column(nullable: true)]
    private ?int $statut = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $dateUpdate = null;

    /**
     * @var Collection<int, Regroupement>
     */
    #[ORM\OneToMany(targetEntity: Regroupement::class, mappedBy: 'Affaire', orphanRemoval: true)]
    private Collection $regroupements;

    #[ORM\Column]
    private ?\DateTime $DateMiseDispo = null;

    /**
     * @var Collection<int, Heure>
     */
    #[ORM\OneToMany(targetEntity: Heure::class, mappedBy: 'affaire')]
    private Collection $heures;

    #[ORM\Column(nullable: true)]
    private ?int $numeroSemainePlanification = null;

    public function __construct()
    {
        $this->detailAffaire = new ArrayCollection();
        $this->regroupements = new ArrayCollection();
        $this->heures = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getClient(): ?string
    {
        return $this->client;
    }

    public function setClient(?string $client): static
    {
        $this->client = $client;

        return $this;
    }

    public function getNomChantier(): ?string
    {
        return $this->nomChantier;
    }

    public function setNomChantier(string $nomChantier): static
    {
        $this->nomChantier = $nomChantier;

        return $this;
    }

    public function getDateFabrication(): ?\DateTimeInterface
    {
        return $this->dateFabrication;
    }

    public function setDateFabrication(?\DateTimeInterface $dateFabrication): static
    {
        $this->dateFabrication = $dateFabrication;

        return $this;
    }

    public function getDateLivraison(): ?\DateTimeInterface
    {
        return $this->dateLivraison;
    }

    public function setDateLivraison(?\DateTimeInterface $dateLivraison): static
    {
        $this->dateLivraison = $dateLivraison;

        return $this;
    }

    public function isAssemblageAtelier(): ?bool
    {
        return $this->assemblageAtelier;
    }

    public function setAssemblageAtelier(?bool $assemblageAtelier): static
    {
        $this->assemblageAtelier = $assemblageAtelier;

        return $this;
    }

    public function getTraitement(): ?string
    {
        return $this->traitement;
    }

    public function setTraitement(?string $traitement): static
    {
        $this->traitement = $traitement;

        return $this;
    }

    public function isTaillageTete(): ?bool
    {
        return $this->taillageTete;
    }

    public function setTaillageTete(?bool $taillageTete): static
    {
        $this->taillageTete = $taillageTete;

        return $this;
    }

    public function isTaillageRefilage(): ?bool
    {
        return $this->taillageRefilage;
    }

    public function setTaillageRefilage(?bool $taillageRefilage): static
    {
        $this->taillageRefilage = $taillageRefilage;

        return $this;
    }

    public function isTaillageDelardement(): ?bool
    {
        return $this->taillageDelardement;
    }

    public function setTaillageDelardement(?bool $taillageDelardement): static
    {
        $this->taillageDelardement = $taillageDelardement;

        return $this;
    }

    public function getEssence(): ?string
    {
        return $this->essence;
    }

    public function setEssence(?string $essence): static
    {
        $this->essence = $essence;

        return $this;
    }

    public function getColle(): ?string
    {
        return $this->colle;
    }

    public function setColle(string $colle): static
    {
        $this->colle = $colle;

        return $this;
    }

    public function getHumidite(): ?string
    {
        return $this->humidite;
    }

    public function setHumidite(?string $humidite): static
    {
        $this->humidite = $humidite;

        return $this;
    }

    public function isBatimentIndustriel(): ?bool
    {
        return $this->batimentIndustriel;
    }

    public function setBatimentIndustriel(?bool $batimentIndustriel): static
    {
        $this->batimentIndustriel = $batimentIndustriel;

        return $this;
    }

    public function isBatimentAgricole(): ?bool
    {
        return $this->batimentAgricole;
    }

    public function setBatimentAgricole(?bool $batimentAgricole): static
    {
        $this->batimentAgricole = $batimentAgricole;

        return $this;
    }

    public function isBatimentSportif(): ?bool
    {
        return $this->batimentSportif;
    }

    public function setBatimentSportif(?bool $batimentSportif): static
    {
        $this->batimentSportif = $batimentSportif;

        return $this;
    }

    public function isBatimentEquestre(): ?bool
    {
        return $this->batimentEquestre;
    }

    public function setBatimentEquestre(?bool $batimentEquestre): static
    {
        $this->batimentEquestre = $batimentEquestre;

        return $this;
    }

    public function isBatimentCulturel(): ?bool
    {
        return $this->batimentCulturel;
    }

    public function setBatimentCulturel(?bool $batimentCulturel): static
    {
        $this->batimentCulturel = $batimentCulturel;

        return $this;
    }

    public function isBatimentAutre(): ?bool
    {
        return $this->batimentAutre;
    }

    public function setBatimentAutre(?bool $batimentAutre): static
    {
        $this->batimentAutre = $batimentAutre;

        return $this;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function setReference(string $reference): static
    {
        $this->reference = $reference;

        return $this;
    }

    public function getAdresseChantier(): ?string
    {
        return $this->adresseChantier;
    }

    public function setAdresseChantier(?string $adresseChantier): static
    {
        $this->adresseChantier = $adresseChantier;

        return $this;
    }

    public function getDateImport(): ?\DateTimeInterface
    {
        return $this->dateImport;
    }

    public function setDateImport(\DateTimeInterface $dateImport): static
    {
        $this->dateImport = $dateImport;

        return $this;
    }

    public function getDessinateur(): ?string
    {
        return $this->dessinateur;
    }

    public function setDessinateur(?string $dessinateur): static
    {
        $this->dessinateur = $dessinateur;

        return $this;
    }

    public function getNomFichiersExcel(): ?string
    {
        return $this->nomFichiersExcel;
    }

    public function setNomFichiersExcel(?string $nomFichiersExcel): static
    {
        $this->nomFichiersExcel = $nomFichiersExcel;

        return $this;
    }

    /**
     * @return Collection<int, DetailAffaire>
     */
    public function getDetailAffaire(): Collection
    {
        return $this->detailAffaire;
    }

    public function addDetailAffaire(DetailAffaire $detailAffaire): static
    {
        if (!$this->detailAffaire->contains($detailAffaire)) {
            $this->detailAffaire->add($detailAffaire);
            $detailAffaire->setAffaire($this);
        }

        return $this;
    }

    public function removeDetailAffaire(DetailAffaire $detailAffaire): static
    {
        if ($this->detailAffaire->removeElement($detailAffaire)) {
            // set the owning side to null (unless already changed)
            if ($detailAffaire->getAffaire() === $this) {
                $detailAffaire->setAffaire(null);
            }
        }

        return $this;
    }

    public function getDateDelete(): ?\DateTimeInterface
    {
        return $this->dateDelete;
    }

    public function setDateDelete(?\DateTimeInterface $dateDelete): static
    {
        $this->dateDelete = $dateDelete;

        return $this;
    }

    public function getStatut(): ?int
    {
        return $this->statut;
    }

    public function setStatut(?int $statut): static
    {
        $this->statut = $statut;

        return $this;
    }

    public function getDateUpdate(): ?\DateTimeInterface
    {
        return $this->dateUpdate;
    }

    public function setDateUpdate(?\DateTimeInterface $dateUpdate): static
    {
        $this->dateUpdate = $dateUpdate;

        return $this;
    }

    /**
     * @return Collection<int, Regroupement>
     */
    public function getRegroupements(): Collection
    {
        return $this->regroupements;
    }

    public function addRegroupement(Regroupement $regroupement): static
    {
        if (!$this->regroupements->contains($regroupement)) {
            $this->regroupements->add($regroupement);
            $regroupement->setAffaire($this);
        }

        return $this;
    }

    public function removeRegroupement(Regroupement $regroupement): static
    {
        if ($this->regroupements->removeElement($regroupement)) {
            // set the owning side to null (unless already changed)
            if ($regroupement->getAffaire() === $this) {
                $regroupement->setAffaire(null);
            }
        }

        return $this;
    }

    public function getDateMiseDispo(): ?\DateTime
    {
        return $this->DateMiseDispo;
    }

    public function setDateMiseDispo(\DateTime $DateMiseDispo): static
    {
        $this->DateMiseDispo = $DateMiseDispo;

        return $this;
    }

    /**
     * @return Collection<int, Heure>
     */
    public function getHeures(): Collection
    {
        return $this->heures;
    }

    public function addHeure(Heure $heure): static
    {
        if (!$this->heures->contains($heure)) {
            $this->heures->add($heure);
            $heure->setAffaire($this);
        }

        return $this;
    }

    public function removeHeure(Heure $heure): static
    {
        if ($this->heures->removeElement($heure)) {
            // set the owning side to null (unless already changed)
            if ($heure->getAffaire() === $this) {
                $heure->setAffaire(null);
            }
        }

        return $this;
    }

    public function getNumeroSemainePlanification(): ?int
    {
        return $this->numeroSemainePlanification;
    }

    public function setNumeroSemainePlanification(?int $numeroSemainePlanification): static
    {
        $this->numeroSemainePlanification = $numeroSemainePlanification;

        return $this;
    }
}
