<?php

namespace App\Controller;

use App\Entity\User;
use App\Form\UserTypeForm;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

final class UtilisateurController extends AbstractController
{
    private $em;
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }
    
    #[Route('/admin/utilisateur', name: 'app_admin_utilisateur')]
    public function index(): Response
    {
       $users = $this->em->getRepository(User::class)->getListeUsers();
        
        return $this->render('admin/utilisateur/index.html.twig', [
            'controller_name' => 'UtilisateurController',
            'users' => $users,
        ]);
    }

    #[Route('/admin/utilisateur/new', name: 'admin_user_new')]
    #[IsGranted('ROLE_ADMIN')]
    public function new(Request $request, EntityManagerInterface $em): Response
    {
        $user = new User();

        $form = $this->createForm(UserTypeForm::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // Gérer un mot de passe par défaut si tu veux
            $user->setPassword(password_hash('changeme', PASSWORD_BCRYPT));

            $em->persist($user);
            $em->flush();

            $this->addFlash('success', 'Utilisateur créé avec succès.');
            return $this->redirectToRoute('app_admin_utilisateur');
        }

        return $this->render('admin/utilisateur/new.html.twig', [
            'form' => $form->createView(),
        ]);
    }

}
