<?php

namespace App\Controller;

use App\Entity\Affaire;
use App\Entity\Regroupement;
use App\Entity\DetailAffaire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

final class RegroupementController extends AbstractController
{
    private $em;
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    #[Route('/prod/regroupement', name: 'app_regroupement')]
    public function index(): Response
    {
        return $this->render('regroupement/index.html.twig', [
            'controller_name' => 'RegroupementController',
        ]);
    }

    #[Route('/prod/regroupement/creer', name: 'regroupement_creer', methods: ['POST'])]
    public function creerRegroupement(Request $request): JsonResponse
    {
        $detailsAffaireRepo = $this->em->getRepository(DetailAffaire::class);
        $data = json_decode($request->getContent(), true);
        $ids = $data['poutres'] ?? [];
        $nbPieces = $data['nbPieces'] ?? 1;
        $longueurFinale = $data['longueurFinale'] ?? 0;

        if (count($ids) < 1) {
            return new JsonResponse(['error' => 'Sélection insuffisante'], 400);
        }

        $poutres = $detailsAffaireRepo->findBy(['id' => $ids]);
        $longueurTotale = array_sum(array_map(fn($p) => $p->getLongueurProduction(), $poutres));        
        $volumeTotal = array_sum(array_map(fn($p) => $p->getVolumefini(), $poutres));
        $regroupement = new Regroupement();
        $regroupement->setLongueurTotale($longueurTotale);
        $regroupement->setVolumeTotal($volumeTotal);
        $regroupement->setQuantite($nbPieces);
        $regroupement->setLongueurFinale($longueurFinale);
        
        foreach ($poutres as $poutre) {
            $regroupement->addPoutre($poutre);
        }
        // Déduction de l'affaire
        if ($poutres) {
            $regroupement->setAffaire($poutres[0]->getAffaire());
        }

        $this->em->persist($regroupement);
        $this->em->flush();

        return new JsonResponse(['success' => true]);
    }
    
    #[Route('/prod/regroupement/detail-affaire/{id}', name: 'app_regroupement_detail_affaire')]
    public function regroupementParDetailAffaire(Affaire $affaire): Response
    {
       $lDetailsAffaire = $this->em->getRepository(DetailAffaire::class)->getListeDetailParAffaire($affaire);
       $regroupements = $this->em->getRepository(Regroupement::class)->findByAffaire($affaire);
        return $this->render('regroupement/index.html.twig', [            
            'poutres' => $lDetailsAffaire,   
            'regroupements'=> $regroupements,
            'affaire'=> $affaire,  
        ]);
    }
   
    #[Route('/prod/regroupement/{id}/supprimer', name: 'regroupement_supprimer', methods: ['POST'])]
    public function supprimer(Regroupement $regroupement, EntityManagerInterface $em): RedirectResponse
    {
        $poutre = $regroupement->getPoutres()->first();
        $affaire = $poutre ? $poutre->getAffaire() : null;

        $em->remove($regroupement);
        $em->flush();

        if ($affaire) {
            return $this->redirectToRoute('app_regroupement_detail_affaire', ['id' => $affaire->getId()]);
        }

        return $this->redirectToRoute('app_affaire');
    }
}