<?php

namespace App\Controller;

use DateTime;
use App\Entity\Banc;
use App\Form\BancType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Security\Csrf\CsrfTokenManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

final class BancController extends AbstractController
{
    private $em;
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }
    
    #[Route('/prod/banc', name: 'app_admin_banc')]
    public function index(): Response
    {
       $bancs = $this->em->getRepository(Banc::class)->getListeBancs();
        
        return $this->render('admin/banc/index.html.twig', [
            'controller_name' => 'BancController',
            'bancs' => $bancs,
        ]);
    }
    
    #[Route('/admin/banc/ajouter', name: 'app_admin_banc_ajouter')]
    public function ajouterBanc(Request $request): Response
    {        
        $banc = new Banc();
        $form = $this->createForm(BancType::class, $banc);
        $form->handleRequest($request);
    
        if ($form->isSubmitted()) {
            if ($form->isValid()) {
                $banc->setDateCreate(new DateTime());
    
                $this->em->persist($banc);
                $this->em->flush();
    
                $this->addFlash('success', "Création du nouveau Banc réussie.");
                return $this->redirectToRoute('app_admin_banc');
            } else {
                // Affiche clairement les erreurs dans la barre de debug de Symfony
                dump($form->getErrors(true));
            }
        }
    
        return $this->render('admin/banc/form.html.twig', [
            'form' => $form->createView(),
        ]);
    }
     
    #[Route('/prod/banc/modifier/{id}', name: 'app_admin_banc_modifier')]
    public function modifierBanc (Request $request, Banc $banc): Response
    {        
        $form = $this->createForm(BancType::class, $banc);
        $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {

                $banc->setDateUpdate(new \DateTime('now'));
                $this->em->persist($banc);
                $this->em->flush();
            
                // Message flash de succès
                $this->addFlash('success', "Le banc \"{$banc->getDesignation()}\" a été modifié avec succès.");
                return $this->redirectToRoute('app_admin_banc');
            }

            return $this->render('admin/banc/form.html.twig', [
                'form' => $form->createView(),
            ]);        
    }

   #[Route('/admin/banc/{id}/delete-token', name: 'banc_delete_token', methods: ['GET'])]
    public function getDeleteToken(int $id, CsrfTokenManagerInterface $csrfTokenManager): JsonResponse
    {
        $token = $csrfTokenManager->getToken('delete'.$id)->getValue();
        return new JsonResponse(['token' => $token]);
    }

    #[Route('/admin/banc/{id}/delete', name: 'banc_delete', methods: ['POST'])]
    public function delete(Request $request, Banc $banc): Response
    {
        // Vérification du token CSRF avant de procéder à la suppression
        $submittedToken = $request->request->get('_token');
        if (!$this->isCsrfTokenValid('delete'.$banc->getId(), $submittedToken)) {
            $this->addFlash('danger', 'Échec de la suppression : token CSRF invalide.');
            return $this->redirectToRoute('app_admin_banc');
        }

        // Suppression de l'entité Banc
        //$entityManager->remove($banc);
        $banc->setDateDelete(new \DateTime('now'));
        $this->em->persist($banc);
        $this->em->flush();

        // Message flash de succès
        $this->addFlash('success', "Le banc \"{$banc->getDesignation()}\" a été supprimé avec succès.");

        // Redirection vers la liste (page index des bancs)
        return $this->redirectToRoute('app_admin_banc', [], Response::HTTP_SEE_OTHER);
    }


    #[Route('/api/bancs/{id}', name: 'api_banc_show', methods: ['GET'])]
    public function show(Banc $banc): JsonResponse
    {
        return $this->json([
            'id' => $banc->getId(),
            'nombre_couche' => $banc->getNombreCouche(),
            'designation' => $banc->getDesignation(),
            'longueurBanc'=> $banc->getLongueurMax(),
            'largeurMax' => $banc->getLargeurMax()
        ]);
    }
}
