<?php 
// src/Controller/BadgeageController.php

namespace App\Controller;

use App\Entity\User;
use App\Entity\Heure;
use DateTimeImmutable;
use App\Form\HeureTypeForm;
use App\Repository\UserRepository;
use App\Repository\HeureRepository;
use DateTime;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class BadgeageController extends AbstractController
{
    #[Route('/badgeage/login', name: 'badgeage_login')]
    public function login(): Response
    {
        return $this->render('heure/login.html.twig');
    }

    #[Route('/badgeage/journee', name: 'badgeage_journee', methods: ['POST'])]
    public function journee(Request $request, UserRepository $userRepository, HeureRepository $heureRepository): Response
    {
        $matricule = $request->request->get('matricule');
        $user = $userRepository->findOneBy(['matricule' => $matricule]);

        if (!$user) {
            $this->addFlash('danger', 'Matricule inconnu.');
            return $this->redirectToRoute('badgeage_login');
        }

        $date = new \DateTimeImmutable();
        $heures = $heureRepository->findByUserAndDate($user, $date);

        return $this->render('heure/journee.html.twig', [
            'user' => $user,
            'heures' => $heures,
        ]);
    }

    #[Route('/badgeage/journee/liste', name: 'badgeage_liste_journee')]
    public function journeeList(Request $request, HeureRepository $heureRepository): Response
    {
        
        $user = $this->getUser();
        if (!$user) {
            $this->addFlash('danger', 'Utilisateur inconnu.');
            return $this->redirectToRoute('app_login');
        }

        $date = new \DateTimeImmutable();
        $heures = $heureRepository->findByUserAndDate($user, $date);

        return $this->render('heure/journee.html.twig', [
            'user' => $user,
            'heures' => $heures,
        ]);
    }

    #[Route('/badgeage/add-tache', name: 'badgeage_add_tache')]
    public function addTache(Request $request, EntityManagerInterface $em): Response
    {
        $user = $this->getUser();
        $heure = new Heure();

        $form = $this->createForm(HeureTypeForm::class, $heure);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // Optionnel : définir automatiquement user, badgeAuto etc.
            $heure->setUser($user);
            $em->persist($heure);
            $em->flush();

            return $this->redirectToRoute('badgeage_liste_journee');
        }

        return $this->render('heure/add_tache.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/badgeage/pause-midi', name: 'badgeage_pause_midi')]
    public function pauseMidi(EntityManagerInterface $em): Response
    {
        // Création automatique d'une pause de midi de 1h
        $user = $this->getUser();
        $heure = new Heure();
        //$heure->setTache('Pause déjeuner');
        $heure->setTypeHeure('Pause déjeuner');
        $heure->setSecteur('pause');        
        $heure->setDate((new \DateTime())->setTime(0, 0));
        $heure->setHeureDebut(\DateTime::createFromImmutable(new \DateTimeImmutable('12:00')));
        $heure->setHeureFin(\DateTime::createFromImmutable(new \DateTimeImmutable('13:30')));
        $heure->setUser( $user);    
        $heure->setBadgeAuto(true);
        $heure->setModifieParManager(false);

        // À adapter si User est connu via session ou login
        $em->persist($heure);
        $em->flush();

        return $this->redirectToRoute('badgeage_liste_journee');
    }

    #[Route('/badgeage/synthese', name: 'badgeage_synthese')]
    public function synthese(HeureRepository $heureRepository): Response
    {
        // À adapter selon user connecté ou session
        $user = $this->getUser();
        $date = new \DateTimeImmutable();
        $heures = $heureRepository->findByUserAndDate($user, $date);

        return $this->render('heure/synthese.html.twig', [
            'heures' => $heures,
        ]);
    }

    #[Route('/badgeage/valider', name: 'badgeage_valider', methods: ['POST'])]
    public function valider(EntityManagerInterface $em): Response
    {
        // Marquer les heures comme prêtes pour export vers CEGID
        // Peut nécessiter un champ `valide` à ajouter à l'entité Heure

        $this->addFlash('success', 'Heures validées pour export.');
        return $this->redirectToRoute('badgeage_login');
    }
}
