<?php

namespace App\Controller;

use App\Entity\Affaire;
use App\Form\AffaireType;
use App\Entity\DetailAffaire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Security\Csrf\CsrfTokenManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

final class AffaireController extends AbstractController
{
    private $em;
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }
   
    #[Route('/prod/affaire', name: 'app_affaire')]
    public function index(): Response
    {
        $affaireRepo = $this->em->getRepository(Affaire::class); 
        $affaires = $affaireRepo->getListeAffaires();
        $statsRegroupee = $this->em->getRepository(DetailAffaire::class)->countRegroupeesParAffaires();
        // Récupère les stats
        $statsAffaire = $affaireRepo->getStatsPoutresParAffaire($this->em);
        // Transforme en tableau indexé par id d'affaire
        $statsIndexes = [];
        foreach ($statsAffaire as $stat) {
            $statsIndexes[$stat['affaire_id']] = $stat;
        }
        return $this->render('affaire/index.html.twig', [
            'controller_name' => 'AffaireController',
            'affaires' => $affaires,
            'statsRegroupee'=>$statsRegroupee,
            'stats' => $statsIndexes
        ]);
    }

    #[Route('/prod/affaire/modifier/{id}', name: 'app_affaire_modifier')]
    public function modifierBanc (Request $request, Affaire $affaire): Response
    {        
        $detailsAffaire = $this->em->getRepository(DetailAffaire::class)->getListeDetailParAffaire($affaire);
        $form = $this->createForm(AffaireType::class, $affaire);
        $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {

                $affaire->setDateUpdate(new \DateTime('now'));
                $this->em->persist($affaire);
                $this->em->flush();
            
                // Message flash de succès
                $this->addFlash('success', "L'affaire \"{$affaire->getNomChantier()}\" a été modifié avec succès.");
                //return $this->redirectToRoute('app_affaire');
            }

            return $this->render('affaire/form.html.twig', [
                'form' => $form->createView(),
                'affaire'=> $affaire,
                'detailsAffaire'=> $detailsAffaire,
            ]);        
    }

    #[Route('/prod/affaire/{id}/delete-token', name: 'affaire_delete_token', methods: ['GET'])]
    public function getDeleteToken(int $id, CsrfTokenManagerInterface $csrfTokenManager): JsonResponse
    {
        $token = $csrfTokenManager->getToken('delete'.$id)->getValue();
        return new JsonResponse(['token' => $token]);
    }

    #[Route('/prod/affaire/{id}/delete', name: 'affaire_delete', methods: ['POST'])]
    public function delete(Request $request, Affaire $affaire): Response
    {
        // Vérification du token CSRF avant de procéder à la suppression
        $submittedToken = $request->request->get('_token');
        if (!$this->isCsrfTokenValid('delete'.$affaire->getId(), $submittedToken)) {
            $this->addFlash('danger', 'Échec de la suppression : token CSRF invalide.');
            return $this->redirectToRoute('app_admin_banc');
        }

        // Suppression de l'entité Banc
        //$entityManager->remove($banc);
        $now = new \DateTime('now');
        $affaire->setDateDelete(new \DateTime('now'));
        $nomFichier = $affaire->getNomFichiersExcel();
        $nomChantier = $affaire->getNomChantier();
        $affaire->setNomChantier('SUPPR-'.$now->format('YmdHis').'-'.$nomChantier);
        $affaire->setNomFichiersExcel('SUPPR-'.$now->format('YmdHis').'-'.$nomFichier);
        $this->em->persist($affaire);
        $lDetailAffaire = $affaire->getDetailAffaire();
        foreach($lDetailAffaire as $da){
            $da->setDateDelete(new \DateTime('now'));
            $this->em->persist($da);
        }
        $this->em->flush();

        // Message flash de succès
        $this->addFlash('success', "L'affaire' \"{$nomChantier}\" a été supprimée avec succès.");

        // Redirection vers la liste (page index des bancs)
        return $this->redirectToRoute('app_affaire', [], Response::HTTP_SEE_OTHER);
    }
}
